@ECHO OFF 
CLS
COLOR E0
:: # AUTOMATED SIM-ON-A-STICK RUN
:: # INSTRUCTIONS:
:: # Optional: Create a shortcut to OpenSim_autostart.bat on your desktop
:: # Lines beginning with REM or :: are REMarks and are ignored by Windows
::
:: set BinPath according to the actual directories used
set BinPath=.\diva-r18222-c\bin
:: 
:: ================================================================================
:: MENU SYSTEM HERE ::
:: test to see if we have configured yet, YES goto startup, NO goto config
IF EXIST .\configured.txt (
GOTO :STARTUP
) ELSE (
GOTO :CONFIG
)
::
:CONFIG
::  
    COLOR 0E
    @echo =========================================
    @echo =       CONFIGURATION OPTIONS           =    
    @echo -----------------------------------------
    @echo 1 = 1 Single Region 256m x 256m
    @echo 2 = 4 Single Regions arranged in 2x2 grid
    @echo 3 = 1 Mega-Region 512m x 512m (2x2 grid)
    @echo =========================================
    :: choice /C:123 /T:100 /D 1 /M "Select desired configuration: "
    choose32 -c 123 -T 1,100 -d 1 -p "Select desired configuration: "
    IF ERRORLEVEL 3 goto Sel_3
    IF ERRORLEVEL 2 goto Sel_2
    IF ERRORLEVEL 1 goto Sel_1 
:Sel_1
    :: rename existing region config to preserve it as we are creating a new Single Region one
    rename %BinPath%\Regions\RegionConfig.ini RegionConfig.ini.txt
    ::
    @echo "1 Single Region 256m x 256m  selected"
    @echo "1 Single Region 256m x 256m  selected" >.\configured.txt
    :: create the single regionconfig.ini
    :: NOTE THIS USES INIFILE 1.6 from http://www.horstmuc.de/wbat32.htm#inifile
    :: DOWNLOAD FROM:  http://www.horstmuc.de/win/inifile.zip
    echo ; Single region configuration >%BinPath%\Regions\Region.ini
    inifile %BinPath%\Regions\Region.ini [simonastick 1] RegionUUID = "c30bf495-02df-4cb6-a459-33b5da4635d6" 
    inifile %BinPath%\Regions\Region.ini [simonastick 1] Location = "1889,2060"
    inifile %BinPath%\Regions\Region.ini [simonastick 1] InternalAddress = "0.0.0.0"
    inifile %BinPath%\Regions\Region.ini [simonastick 1] InternalPort = 9100
    inifile %BinPath%\Regions\Region.ini [simonastick 1] AllowAlternatePorts = False
    inifile %BinPath%\Regions\Region.ini [simonastick 1] ExternalHostName = "127.0.0.1"
    :: now fix the INI for NON-MEGA
    INIFILE %BinPath%\config-include\DivaPreferences.ini [Startup] CombineContiguousRegions=false
    goto :FixMySql
:Sel_2
    :: If we created a single region.ini previously, preserve it and bring back the quad region RegionConfig.ini
    if exist %BinPath%\Regions\Region.ini REN %BinPath%\Regions\Region.ini Region.ini.txt
    if exist %BinPath%\Regions\RegionConfig.ini.txt REN %BinPath%\Regions\RegionConfig.ini.txt RegionConfig.ini
    ::
    @echo "4 Single Regions arranged in 2x2 grid"
    @echo "4 Single Regions arranged in 2x2 grid" >.\configured.txt
    :: now fix the INI for NON-MEGA
    INIFILE %BinPath%\config-include\DivaPreferences.ini [Startup] CombineContiguousRegions=false
    goto :FixMySql
:Sel_3
    if exist %BinPath%\Regions\Region.ini REN %BinPath%\Regions\Region.ini Region.ini.txt
    if exist %BinPath%\Regions\RegionConfig.ini.txt REN %BinPath%\Regions\RegionConfig.ini.txt RegionConfig.ini
    ::
    @echo "1 Mega-Region 512m x 512m (2x2 grid)"
    @echo "1 Mega-Region 512m x 512m (2x2 grid)" >.\configured.txt
    :: now fix (verify)the INI for MEGA Region use
    INIFILE %BinPath%\config-include\DivaPreferences.ini [Startup] CombineContiguousRegions=true    
    goto :FixMySql
:FixMySql
    :: MySql requires a few minor adjustments to allow the proper saving of OAR & IAR files as this is DB intensive
    :: this is accomplished here 
    inifile .\mysql\my.ini [mysqld] max_allowed_packet = 16M
    inifile .\mysql\my.ini [mysqldump] max_allowed_packet = 16M
    goto :STARTUP
:: ================================================================================
:STARTUP
::  Normal Script resumes as previously done
    COLOR E0
    @ECHO INITIATING OPENSIM AUTOSTART
    @ECHO.
    @ECHO Loading MoWeS, waiting 20 seconds ...
    @ECHO.
    ::
    START "MOWES" "mowes.exe"   
    ::
    REM # SLEEP A WHILE BY FORCING SOME PING COMMANDS
    REM increase the number after -n for longer wait:
    @ping 127.0.0.1 -n 20 -w 1000 > nul 
    @ping 127.0.0.1 -n %1% -w 1000> nul
    @ECHO MoWeS should now be running
    @ECHO.
    @ECHO.
    COLOR 30
    @ECHO Loading Diva Distro
    @ECHO.
    :: changing to binary directory
    CD %BinPath%  
    :: ================================================================================
    :: set a flag we can test against 
    set x86os=false
    :: test to see if the (x86) dirs exist, if yes then we are 64bit so set x86os flag to true
    If Defined ProgramFiles(x86) set x86os=true
    echo Starting OpenSim ( X86/64bit mode = %x86os% )
    :: depending on x86os flag, start accordingly.
    if %x86os% == true  START "DIVA-64Bit-Mode" /b "OpenSim.32BitLaunch.exe" 
    if %x86os% == false START "DIVA-32Bit-Mode" /b "OpenSim.exe" 
    ::
    :: ================================================================================
REM # SLEEP A WHILE BY FORCING SOME PING COMMANDS
REM increase the number after -n for longer wait:
@ping 127.0.0.1 -n 45 -w 1000 > nul   
@ping 127.0.0.1 -n %1% -w 1000> nul
@ECHO --------------------------------
@ECHO.
@ECHO OpenSim Diva-Distro should be running now.
@ECHO.
@ECHO.
COLOR 0E
@ECHO To end OpenSim - Type shutdown in the command console and hit Enter 
@ECHO Then select End in MoWes to shutdown Apache and MySql and exit MoWes.
@ECHO.
@ECHO STARTING THE IMPRUDENCE VIEWER
@ECHO.
@ECHO.
CD ..
CD ..
CD "Imprudence" 
START "VIEWER" "imprudence.exe"
::